
function ISInventoryPane:canPutIn()

    if self.inventory == nil then
        return false;
    end
    if self.inventory:getType() == "floor" then
        return true;
    end

    if self.inventory:getParent() == getSpecificPlayer(self.player) then
        return true;
    end

    -- If the lightest item fits, allow the transfer.
    local minWeight = 100000
    local dragging = ISInventoryPane.getActualItems(ISMouseDrag.dragging)
    for i,v in ipairs(dragging) do
        -- you can't draw the container in himself
        if (self.inventory:isInside(v)) then
            return false;
        end
        local inv = self.inventory;
        if self.mouseOverButton and self.mouseOverButton.inventory then
            inv = self.mouseOverButton.inventory;
        end
        --if not inv:isItemAllowed(v) then
        if not IsAllowedIn(inv,v) then
            return false;
        end
        if v:getUnequippedWeight() < minWeight then
            minWeight = v:getUnequippedWeight()
        end
    end
    if #dragging == 1 then
        return self.inventory:hasRoomFor(getSpecificPlayer(self.player), dragging[1])
    end
    return self.inventory:hasRoomFor(getSpecificPlayer(self.player), minWeight)
end
